/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import net.skinsrestorer.shadow.axiom.AxiomConfiguration;

public class YamlConfig {
    private final Path file;
    private final AxiomConfiguration config = new AxiomConfiguration();
    private final AxiomConfiguration defaultConfig = new AxiomConfiguration();

    public YamlConfig(Path file) {
        this.file = file;
        Path parent = file.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void loadConfig(InputStream is) {
        if (Files.exists(this.file, new LinkOption[0])) {
            try {
                this.load();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (is != null) {
                try {
                    this.defaultConfig.load(is);
                    String beforeMerge = this.config.saveToString();
                    this.config.merge(this.defaultConfig, true, true, false);
                    if (!beforeMerge.equals(this.config.saveToString())) {
                        this.config.save(this.file);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (is == null) {
            try {
                Files.createFile(this.file, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.defaultConfig.load(is);
                this.defaultConfig.save(this.file);
                this.load();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Boolean getBoolean(String path) {
        Boolean value = this.config.getBoolean(path);
        if (value == null) {
            return this.defaultConfig.getBoolean(path);
        }
        return value;
    }

    public Boolean getBoolean(String path, Boolean defValue) {
        Boolean value = this.config.getBoolean(path);
        return value == null ? defValue : value;
    }

    public Integer getInt(String path) {
        Integer value = this.config.getInt(path);
        if (value == null) {
            return this.defaultConfig.getInt(path);
        }
        return value;
    }

    public Integer getInt(String path, Integer defValue) {
        Integer value = this.config.getInt(path);
        return value == null ? defValue : value;
    }

    public String getString(String path) {
        String value = this.config.getString(path);
        if (value == null) {
            return this.defaultConfig.getString(path);
        }
        return value;
    }

    public String getString(String path, String defValue) {
        String value = this.config.getString(path);
        return value == null ? defValue : value;
    }

    public List<String> getStringList(String path) {
        List<String> value = this.config.getStringList(path);
        if (value == null) {
            return this.defaultConfig.getStringList(path);
        }
        return value;
    }

    public List<String> getStringList(String path, String whatToDelete) {
        return this.getStringList(path).stream().map(str -> str.replace(whatToDelete, "")).collect(Collectors.toList());
    }

    public void load() throws IOException {
        this.config.load(this.file);
    }

    public void save() throws IOException {
        this.config.save(this.file);
    }

    public void set(String path, Object value) {
        try {
            this.config.set(path, value);
            this.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

